/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.IVWSIMAnimationDP;
import filenet.sim.animationdp.IVWSIMEvent;
import filenet.sim.animationdp.impl2.AnimationManager;
import filenet.sim.animationdp.impl2.IVWSIMEventBuffer;
import filenet.sim.animationdp.impl2.IVWSIMEventReader;
import filenet.sim.animationdp.impl2.RetrievalThread;
import filenet.sim.animationdp.impl2.VWSIMFileEventBuffer;
import filenet.sim.animationdp.impl2.VWSIMMemEventBuffer;
import filenet.sim.animationdp.impl2.VWSimLocalFileReader;
import filenet.sim.api.VWSIMNoProcessSimulatorException;
import filenet.sim.api.VWSIMSimulation;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.appserver.IVWSIMCommand;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import java.io.ByteArrayInputStream;
import simulator.ISimulator;
import simulator.scenario.BasicScenario;

public class VWSIMAnimationDP
implements IVWSIMAnimationDP {
    private String m_scenarioId = null;
    private IVWSIMEventBuffer m_eventBuffer = null;
    private IVWSIMEventReader m_eventReader = null;
    private RetrievalThread m_retrievalThread = null;
    private VWScenarioDefinition m_scenarioDef = null;
    private AnimationManager m_curEvent = new AnimationManager();
    protected static final Logger logger = Logger.getLogger("filenet.sim.animationdp");
    private String m_className = "VWSIMAnimationDP";
    private ConnectionInfo m_connection;

    protected VWSIMAnimationDP() {
    }

    private VWSIMAnimationDP(String scenarioDefinitionFileName, String eventBufferFileName) throws VWException {
        String m_method = "<init>:" + scenarioDefinitionFileName;
        logger.entering(this.m_className, m_method);
        this._loadFromFiles(scenarioDefinitionFileName, eventBufferFileName);
        logger.exiting(this.m_className, m_method);
    }

    private void _loadFromFiles(String scenarioDefinitionFileName, String eventBufferFileName) throws VWException {
        String m_method = "loadFromFiles:" + scenarioDefinitionFileName;
        logger.entering(this.m_className, m_method);
        this.m_eventReader = new VWSimLocalFileReader(eventBufferFileName);
        this.m_scenarioDef = VWScenarioDefinition.readFromFile(scenarioDefinitionFileName);
        this.m_connection = new ConnectionInfo();
        logger.exiting(this.m_className, m_method);
    }

    public static IVWSIMAnimationDP loadFromFiles(String scenarioDefinitionFileName, String eventBufferFileName) throws VWException {
        logger.entering("VWSIMAnimationDP", "loadFromFiles");
        return new VWSIMAnimationDP(scenarioDefinitionFileName, eventBufferFileName);
    }

    public VWSIMAnimationDP(IVWSIMCommand cmd, IVWIDMDocument doc) throws VWException {
        boolean complete;
        String m_method = "ctor:Doc";
        doc.refresh();
        String GUID = (String)doc.getProp("SimulationGUID");
        String statusString = (String)doc.getProp("SimulationStatus");
        boolean bl = complete = statusString != null && statusString.startsWith("4");
        if (complete) {
            int nFiles;
            String[] files = doc.getContentElementsToFile();
            int n = nFiles = files == null ? 0 : files.length;
            if (nFiles < 3) {
                logger.severe(this.m_className, "ctor:Doc", "Sim doc " + GUID + " does not have the required contents!");
                throw new VWSIMNoProcessSimulatorException();
            }
            this.m_eventReader = new VWSimLocalFileReader(files[1], files[2], files[3]);
            this.m_scenarioDef = VWScenarioDefinition.readFromFile(files[0]);
            this.m_connection = new ConnectionInfo();
        } else {
            if (cmd == null) {
                throw new VWException("filenet.sim.animationdp.ex.invalidServerRef", "Failed to get Animation Data Provider.  Invalid server reference.");
            }
            byte[] contents = doc.getContents();
            ByteArrayInputStream is = null;
            if (contents != null) {
                is = new ByteArrayInputStream(contents);
            }
            VWScenarioDefinition scenDef = VWScenarioDefinition.read(is);
            this.loadFromSIMCommand(cmd, GUID, scenDef);
        }
    }

    public VWSIMAnimationDP(IVWSIMCommand cmd, VWSIMSimulation simDoc) throws VWException {
        if (simDoc.isCompleted()) {
            String[] files = simDoc.getContentElementsToFile();
            this.m_eventReader = new VWSimLocalFileReader(files[1], files[2], files[3]);
            this.m_scenarioDef = VWScenarioDefinition.readFromFile(files[0]);
            this.m_connection = new ConnectionInfo();
        } else {
            if (cmd == null) {
                throw new VWException("filenet.sim.animationdp.ex.invalidServerRef", "Failed to get Animation Data Provider.  Invalid server reference.");
            }
            byte[] contents = simDoc.getScenarioXML();
            ByteArrayInputStream is = null;
            if (contents != null) {
                is = new ByteArrayInputStream(contents);
            }
            VWScenarioDefinition scenDef = VWScenarioDefinition.read(is);
            this.loadFromSIMCommand(cmd, simDoc.getSimulationGuid(), scenDef);
        }
    }

    private void loadFromSIMCommand(IVWSIMCommand cmd, String GUID, VWScenarioDefinition scenarioDef) {
        this.m_scenarioDef = scenarioDef;
        this.m_scenarioId = GUID;
        this.m_connection = new ConnectionInfo(cmd, GUID);
        String m_method = "loadFromSIMCommand";
        try {
            if (System.getProperty("filenet.sim.animationdp.mem.eventbuffer") != null) {
                logger.fine(this.m_className, "loadFromSIMCommand", "Getting a memory eventbuffer");
                this.m_eventBuffer = new VWSIMMemEventBuffer(GUID);
            } else {
                logger.fine(this.m_className, "loadFromSIMCommand", "Getting a file eventbuffer");
                this.m_eventBuffer = new VWSIMFileEventBuffer(GUID);
            }
        }
        catch (Exception e) {
            logger.fine(this.m_className, "loadFromSIMCommand", "Get buffer, EX=" + e.getMessage());
            logger.fine(this.m_className, "loadFromSIMCommand", "Getting a memory eventbuffer 2");
            this.m_eventBuffer = new VWSIMMemEventBuffer(GUID);
        }
        logger.fine(this.m_className, "loadFromSIMCommand", "starting retrieval thread");
        this.m_retrievalThread = new RetrievalThread(cmd, GUID, this.m_eventBuffer);
        this.m_retrievalThread.start();
        if (this.m_eventBuffer != null) {
            try {
                logger.fine(this.m_className, "loadFromSIMCommand", "getting event buffer reader");
                this.m_eventReader = this.m_eventBuffer.getReader();
            }
            catch (Exception e) {
                logger.fine(this.m_className, "loadFromSIMCommand", "Got exception.." + e.getMessage());
            }
        }
    }

    public VWSIMAnimationDP(IVWSIMCommand cmd, String GUID, VWScenarioDefinition scenarioDef) {
        this.m_className = this.m_className + ":";
        this.m_className = this.m_className + GUID;
        String m_method = "<init2>";
        logger.entering(this.m_className, m_method);
        this.loadFromSIMCommand(cmd, GUID, scenarioDef);
        logger.exiting(this.m_className, m_method);
    }

    public VWSIMAnimationDP(ISimulator rmiSimulator, String GUID, String scenarioFilename) throws Exception {
        this.m_className = this.m_className + ":IScn:";
        this.m_className = this.m_className + GUID;
        String m_method = "<init3>";
        logger.entering(this.m_className, m_method);
        this.m_scenarioDef = VWScenarioDefinition.readFromFile(scenarioFilename);
        this.m_scenarioId = GUID;
        this.m_connection = new ConnectionInfo(rmiSimulator, GUID);
        try {
            this.m_eventBuffer = System.getProperty("filenet.sim.animationdp.mem.eventbuffer") != null ? new VWSIMMemEventBuffer(GUID) : new VWSIMFileEventBuffer(GUID);
        }
        catch (Exception e) {
            this.m_eventBuffer = new VWSIMMemEventBuffer(GUID);
        }
        this.m_retrievalThread = new RetrievalThread(rmiSimulator, GUID, this.m_eventBuffer);
        this.m_retrievalThread.start();
        if (this.m_eventBuffer != null) {
            try {
                this.m_eventReader = this.m_eventBuffer.getReader();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        logger.exiting(this.m_className, m_method);
    }

    public VWSIMAnimationDP(ISimulator rmiSimulator, BasicScenario scenarioInfo) throws Exception {
        if (scenarioInfo == null || rmiSimulator == null) {
            throw new NullPointerException("ctor for Scenario Info");
        }
        String GUID = scenarioInfo.id;
        this.m_className = this.m_className + ":IScn:";
        this.m_className = this.m_className + GUID;
        String m_method = "<init3>";
        logger.entering(this.m_className, m_method);
        this.m_scenarioDef = VWScenarioDefinition.read(scenarioInfo.scenarioXML);
        this.m_scenarioId = GUID;
        this.m_connection = new ConnectionInfo(rmiSimulator, GUID);
        try {
            this.m_eventBuffer = System.getProperty("filenet.sim.animationdp.mem.eventbuffer") != null ? new VWSIMMemEventBuffer(GUID) : new VWSIMFileEventBuffer(GUID);
        }
        catch (Exception e) {
            this.m_eventBuffer = new VWSIMMemEventBuffer(GUID);
        }
        this.m_retrievalThread = new RetrievalThread(rmiSimulator, GUID, this.m_eventBuffer);
        this.m_retrievalThread.start();
        if (this.m_eventBuffer != null) {
            try {
                this.m_eventReader = this.m_eventBuffer.getReader();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        logger.exiting(this.m_className, m_method);
    }

    public synchronized void restart() throws VWException {
        logger.entering(this.m_className, "restart");
        if (this.m_retrievalThread != null && this.m_retrievalThread.isPaused()) {
            this.m_retrievalThread.goOn();
        }
        if (this.m_eventReader != null) {
            this.m_eventReader.reset();
        }
        if (this.m_curEvent != null) {
            this.m_curEvent = null;
            this.m_curEvent = new AnimationManager();
        }
        logger.exiting(this.m_className, "restart");
    }

    public synchronized void pauseRetrieval() throws VWException {
        logger.entering(this.m_className, "pauseRetrieval");
        if (this.m_retrievalThread != null) {
            this.m_retrievalThread.pause();
        }
        logger.exiting(this.m_className, "pauseRetrieval");
    }

    public synchronized void stopRetrieval() throws VWException {
        logger.entering(this.m_className, "stopRetrieval");
        if (this.m_retrievalThread != null) {
            this.m_retrievalThread.stopRetrieval();
        }
        logger.exiting(this.m_className, "stopRetrieval");
    }

    public synchronized void releaseResources() {
        logger.entering(this.m_className, "releaseResources");
        if (this.m_retrievalThread != null) {
            this.m_retrievalThread.stopRetrieval();
        }
        if (this.m_eventReader != null) {
            this.m_eventReader.releaseResources();
        }
        if (this.m_eventBuffer != null) {
            this.m_eventBuffer.releaseResources();
        }
        if (this.m_curEvent != null) {
            this.m_curEvent = null;
            this.m_curEvent = new AnimationManager();
        }
        logger.exiting(this.m_className, "releaseResources");
    }

    public synchronized IVWSIMEvent getEvent() throws VWException {
        String m_method = "getEvent";
        if (this.m_eventReader == null) {
            logger.fine(this.m_className, "getEvent", "NULL Event Reader!");
            return null;
        }
        try {
            int status;
            AnimationManager simEvent = this.m_eventReader.get();
            if (simEvent != null) {
                this.m_curEvent.merge(simEvent);
            }
            if (this.m_curEvent.finished() && this.m_retrievalThread != null && (status = this.m_retrievalThread.getStatus()) == 65535) {
                String statusMsg = this.m_retrievalThread.getStatusMessage();
                throw new VWException("filenet.sim.animationdp.ex", "Exception: {0}", statusMsg);
            }
        }
        catch (VWException vwex) {
            throw vwex;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, this.m_className, m_method, e.getLocalizedMessage(), e);
            throw new VWException(e);
        }
        if (logger.isFinest()) {
            logger.finest(this.m_className, "getEvent", " returning " + this.m_curEvent.toString());
        }
        return this.m_curEvent;
    }

    public synchronized boolean isTimedOut() {
        return this.m_retrievalThread != null ? this.m_retrievalThread.getTimedOut() : false;
    }

    public synchronized void continueAfterTimeout() {
        if (this.m_retrievalThread != null && this.m_retrievalThread.isPaused()) {
            this.m_retrievalThread.goOn();
        }
    }

    public synchronized VWScenarioDefinition getScenarioDefinition() {
        return this.m_scenarioDef;
    }

    public synchronized void writeToFiles(String scenarioDefinitionFileName, String eventBufferFileName) throws VWException {
        if (eventBufferFileName != null && this.m_eventBuffer != null) {
            this.m_eventBuffer.writeToFile(eventBufferFileName);
        }
        if (scenarioDefinitionFileName != null && this.m_scenarioDef != null) {
            this.m_scenarioDef.writeToFile(scenarioDefinitionFileName);
        }
    }

    public synchronized boolean retrievalFinished() {
        if (this.m_retrievalThread != null) {
            return this.m_retrievalThread.finished();
        }
        return true;
    }

    class ConnectionInfo {
        private boolean local = true;
        private IVWSIMCommand m_cmd = null;
        private ISimulator m_sim = null;
        private String m_guid = null;

        public ConnectionInfo() {
        }

        public ConnectionInfo(IVWSIMCommand cmd, String guid) {
            this.local = false;
            this.m_cmd = cmd;
            this.m_guid = guid;
        }

        public ConnectionInfo(ISimulator sim, String guid) {
            this.m_sim = sim;
            this.m_guid = guid;
        }

        public String getStatistics() {
            try {
                if (this.m_cmd != null) {
                    return this.m_cmd.getStatistics(this.m_guid);
                }
                if (this.m_sim != null) {
                    return this.m_sim.getSimStatisticsInfo(this.m_guid);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

